; Define the location of the runtime files.
#define VFPCoreFiles    "..\..\Runtimes"

; Define the location of the application files.
#define AppFiles        "..\"

[Setup]
OutputBaseFilename=WSSetup
OutputDir=.

AppName={code:GetAppName}
AppVerName={code:GetAppName}
AppVersion={code:GetAppVersion}
DefaultDirName={pf}\{code:GetAppName}
UsePreviousAppDir=no
AppendDefaultDirName=no
DefaultGroupName={code:GetAppName}
Compression=lzma
SolidCompression=true
PrivilegesRequired=admin
VersionInfoDescription=Workstation Installer
; VersionInfoProductName and VersionInfoProductTextVersion are just here to avoid compiler warnings
VersionInfoProductName=.
VersionInfoProductTextVersion=.
UsePreviousLanguage=no
SignTool=Standard /d $qWorkstation Installer$q $f

[Messages]
WelcomeLabel2=This setup will install the necessary runtime files on your computer.%n%nIt is recommended that you close all other applications before continuing.
FinishedLabel=Setup has finished the workstation-only install on your computer. The application may be launched by running one of the installed icons.
SelectTasksLabel2=Select any additional tasks that you would like to perform during setup.
ReadyLabel1=Setup is now ready to begin the workstation-only install on your computer.

[Tasks]
Name: desktopicon; Description: Create a &desktop icon; GroupDescription: Icons

[Code]
var
   SourceDirectoryPage: TOutputMsgWizardPage ;

function GetEXEName(Dummy: String): String;
begin
  Result := GetINIString('Setup', 'EXEName', '', ExpandConstant('{src}') + '\setup.ini') + '.exe';
end;

function GetCHMName(Dummy: String): String;
begin
  Result := GetINIString('Setup', 'EXEName', '', ExpandConstant('{src}') + '\setup.ini') + '.chm';
end;

function GetAppName(Dummy: String): String;
begin
  Result := GetINIString('Setup', 'AppName', '', ExpandConstant('{src}') + '\setup.ini');
end;

function GetAppVersion(Dummy: String): String;
var
  MyVersion: String;
begin
  GetVersionNumbersString(ExpandConstant('{src}') + '\' + GetEXEName(''), MyVersion);
  Result := MyVersion
end;

procedure InitializeWizard();
begin
  SourceDirectoryPage := CreateOutputMsgPage(wpInfoBefore,
    'Information', 'Setup will create a shortcut to the file listed below.',
    'Target Application: ' + ExpandConstant('{src}') + '\' + GetEXEName(''));
end;

function NextButtonClick(CurPageID: Integer): Boolean;
var
  bValidTarget: Boolean;

begin
  bValidTarget := true;
  if (CurPageID = SourceDirectoryPage.ID) and (FileExists(ExpandConstant('{src}') + '\' + GetEXEName('')) = false) then
  begin
    MsgBox('The application file does not exist in the ' + ExpandConstant('{src}') + ' directory. Please run this workstation-only setup file from the server directory where the program is already installed.', mbCriticalError, MB_OK);
    bValidTarget := false;
  end;
  Result := bValidTarget;
end;

[Files]
; This lists any ActiveX controls that need to be registered to work.
Source: "{#VFPCoreFiles}\MSXML4.dll";    DestDir: "{sys}"; Flags: onlyifdoesntexist sharedfile regserver noregerror
Source: "{#VFPCoreFiles}\MSXML4R.dll";   DestDir: "{sys}"; Flags: onlyifdoesntexist sharedfile
Source: "{#VFPCoreFiles}\MSComCtl.ocx";  DestDir: "{sys}"; Flags: onlyifdoesntexist sharedfile regserver noregerror

; We need these files for CHM help to work.
Source: "{#VFPCoreFiles}\foxhhelp9.exe";    DestDir: "{cf}\Microsoft Shared\VFP";  Flags: sharedfile uninsneveruninstall
Source: "{#VFPCoreFiles}\foxhhelpps9.dll";  DestDir: "{cf}\Microsoft Shared\VFP";  Flags: sharedfile uninsneveruninstall

; A VFP COM server needs to be installed and registered locally, but that requires the VFP 9 runtimes too.
Source: "{#VFPCoreFiles}\MSVCR71.dll";   DestDir: "{pf}\My Application";  Flags: ignoreversion deleteafterinstall
Source: "{#VFPCoreFiles}\VFP9R.dll";     DestDir: "{pf}\My Application";  Flags: ignoreversion
Source: "{#VFPCoreFiles}\VFP9T.dll";     DestDir: "{pf}\My Application";  Flags: ignoreversion
Source: "{#VFPCoreFiles}\VFP9REnu.dll";  DestDir: "{pf}\My Application";  Flags: ignoreversion
Source: "{#AppFiles}COMServer.dll";      DestDir: "{pf}\My Application";  Flags: ignoreversion regserver

[Registry]
; These keys allow remote CHM files to be viewed properly.
Root: HKLM; Subkey: "SOFTWARE\Microsoft\HTMLHelp\1.x\ItssRestrictions";             ValueType: dword; ValueName: "MaxAllowedZone"; ValueData: 3
Root: HKLM; Subkey: "SOFTWARE\Wow6432Node\Microsoft\HTMLHelp\1.x\ItssRestrictions"; ValueType: dword; ValueName: "MaxAllowedZone"; ValueData: 3

[Run]
Filename: "{cf}\Microsoft Shared\VFP\foxhhelp9.exe"; Parameters: /regserver
Filename: "{src}\{code:GetEXEName}"; Description: "{cm:LaunchProgram,application}"; Flags: nowait postinstall skipifsilent

[Icons]
Name: "{group}\{code:GetAppName}";         Filename: "{src}\{code:GetEXEName}"; WorkingDir: "{src}"
Name: "{group}\{code:GetAppName} Help";    Filename: "{src}\{code:GetCHMName}"
Name: "{commondesktop}\{code:GetAppName}"; Filename: "{src}\{code:GetEXEName}"; WorkingDir: "{src}"; Tasks: desktopicon
